/*:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::
::   Module      :   Protocol Access API Definition Function Header
::   Copyright   :   (C)2003-2009 Woodward
::   Platform(s) :   MPC5xx
::   Limitations :   None
::
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::*/
/*! \file ProtocolAccess.h
    \brief Many or the protocols support an access level. This access level can also be thought of as a
           privilege level. The higher the value the higher the privileges

    While the access levels are dependant upon the application, some suggested levels are:\n
    - Consumer Tool \ref E_AccessLevel::ACCESS_LEVEL1
    - Dealer Tools \ref E_AccessLevel::ACCESS_LEVEL2
    - Calibration Tools \ref E_AccessLevel::ACCESS_LEVEL3
    - Developer Tools \ref E_AccessLevel::ACCESS_LEVEL4
*/

#ifndef __PROTOCOLACCESS_H
#define __PROTOCOLACCESS_H

/*---- INCLUDE FILES --------------------------------------------------------------------------------------*/
#include <typedefn.h>

/*---- DEFINES --------------------------------------------------------------------------------------------*/

/*---- TYPEDEF --------------------------------------------------------------------------------------------*/
#pragma pack(1)

/*! The security access levels supported by some protocols */
typedef enum
{
    ACCESS_LEVEL1,  /*!< Access level#1. The access level with the least privileges */
    ACCESS_LEVEL2,  /*!< Access level#2. */
    ACCESS_LEVEL3,  /*!< Access level#3. */
    ACCESS_LEVEL4,  /*!< Access level#1. The access level with the most privileges */
    NUM_ACCESS_LEVELS
} E_AccessLevel;

#pragma pack()
/*---- EXTERNALS ------------------------------------------------------------------------------------------*/

/*---- PROTOTYPES -----------------------------------------------------------------------------------------*/

#endif /* __PROTOCOLACCESS_H */

/*---- END OF FILE ----------------------------------------------------------------------------------------*/

